<?php 

	session_start();
	
	if(!isset($_SESSION['contact_mobile'])){
		header("location: login.php");
	}
	
	require_once("includes/constants.php");
	require_once("includes/config_db.php");
	require_once("includes/config.php");
	require_once("includes/ZohoBooks.php");
	
	$current_page = "customerpayments";
	$page_no = 1;
	$next_page = $prev_page = $html_str = $status = $status_options = "";
	
	if( isset($_GET) && isset($_GET['page_no']) && intval($_GET['page_no']) > 0 ){
		$page_no = intval($_GET['page_no']);
	}
	
	if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
		$status = $_GET['status'];
	}
	
	$status_options .= ($status=="" || "PaymentMode.All") ? '<option value="PaymentMode.All" selected>All</option>' : '<option value="PaymentMode.All">All</option>';
	$status_options .= ($status=="PaymentMode.Authorizenet") ? '<option value="PaymentMode.Authorizenet" selected>Authorizenet</option>' : '<option value="PaymentMode.Authorizenet">Authorizenet</option>';
	$status_options .= ($status=="PaymentMode.BankRemittance") ? '<option value="PaymentMode.BankRemittance" selected>BankRemittance</option>' : '<option value="PaymentMode.BankRemittance">BankRemittance</option>';
	$status_options .= ($status=="PaymentMode.BankTransfer") ? '<option value="PaymentMode.BankTransfer" selected>BankTransfer</option>' : '<option value="PaymentMode.BankTransfer">BankTransfer</option>';
	$status_options .= ($status=="PaymentMode.Braintree") ? '<option value="PaymentMode.Braintree" selected>Braintree</option>' : '<option value="PaymentMode.Braintree">Braintree</option>';
	$status_options .= ($status=="PaymentMode.Cash") ? '<option value="PaymentMode.Cash" selected>Cash</option>' : '<option value="PaymentMode.Cash">Cash</option>';
	$status_options .= ($status=="PaymentMode.Check") ? '<option value="PaymentMode.Check" selected>Check</option>' : '<option value="PaymentMode.Check">Check</option>';
	$status_options .= ($status=="PaymentMode.Credit") ? '<option value="PaymentMode.Credit" selected>Credit</option>' : '<option value="PaymentMode.Credit">Credit</option>';
	$status_options .= ($status=="PaymentMode.CreditCard") ? '<option value="PaymentMode.CreditCard" selected>CreditCard</option>' : '<option value="PaymentMode.CreditCard">CreditCard</option>';
	$status_options .= ($status=="PaymentMode.GoogleCheckout") ? '<option value="PaymentMode.GoogleCheckout" selected>GoogleCheckout</option>' : '<option value="PaymentMode.GoogleCheckout">GoogleCheckout</option>';
	$status_options .= ($status=="PaymentMode.Others") ? '<option value="PaymentMode.Others" selected>Others</option>' : '<option value="PaymentMode.Others">Others</option>';
	$status_options .= ($status=="PaymentMode.Payflowpro") ? '<option value="PaymentMode.Payflowpro" selected>Payflowpro</option>' : '<option value="PaymentMode.Payflowpro">Payflowpro</option>';
	$status_options .= ($status=="PaymentMode.Paypal") ? '<option value="PaymentMode.Paypal" selected>Paypal</option>' : '<option value="PaymentMode.Paypal">Paypal</option>';
	$status_options .= ($status=="PaymentMode.Stripe") ? '<option value="PaymentMode.Stripe" selected>Stripe</option>' : '<option value="PaymentMode.Stripe">Stripe</option>';
	$status_options .= ($status=="PaymentMode.TwoCheckout") ? '<option value="PaymentMode.TwoCheckout" selected>TwoCheckout</option>' : '<option value="PaymentMode.TwoCheckout">TwoCheckout</option>';
	
	$zb = new ZohoBooks(ZOHO_AUTHTOKEN, ZOHO_ORGANIZATIONID);
	
	$config = array(
					"customer_id" => $_SESSION['contact_id'],
					"page" => $page_no,
				);
	
	if( $status != "" ){
		$config["filter_by"] = $status;
	}

	$customerpayments = $zb->allCustomerPayments($config);

	$response = json_decode($customerpayments, true);
	
	if( is_array($response) ){
		$customerpayments = $response['customerpayments'];
		$page_context = $response['page_context'];
		$max = sizeof($customerpayments);
		
		/*echo "<pre>";
		print_r($customerpayments[0]);
		echo "</pre>";
		
		echo "<pre>";
		print_r($page_context);
		echo "</pre>";
		return;*/
		
		for($i=0; $i<$max; $i++){
			$status_class = "badge-dark";
		
			if( strtolower($customerpayments[$i]['payment_mode']) == "bank remittance" ){
				$status_class = "badge-info";
			}else if( strtolower($customerpayments[$i]['payment_mode']) == "bank transfer" ){
				$status_class = "badge-info";
			}else if( strtolower($customerpayments[$i]['payment_mode']) == "cash" ){
				$status_class = "badge-info";
			}else if( strtolower($customerpayments[$i]['payment_mode']) == "check" ){
				$status_class = "badge-info";
			}else if( strtolower($customerpayments[$i]['payment_mode']) == "other" ){
				$status_class = "badge-info";
			}
			
			$html_str .= '<div class="card mb-2">
								<div class="card-body">
									<div class="d-sm-flex row flex-wrap text-sm-left align-items-center">
										<div class="col-6 text-left">
											<a href="#" data-payment-id="'. $customerpayments[$i]['payment_id'] .'">
												<h4 class="text-info">'. $customerpayments[$i]['payment_number'] .'</h4>
											</a>
											<h6>Date: <span class="text-muted">'. date('d-M-Y', strtotime($customerpayments[$i]['date'])) .'</span></h6>
											<h6 class="m-0">Ref No: <span class="text-muted">'. $customerpayments[$i]['reference_number'] .'</span></h6>
										</div>
										<div class="col-6 text-right">
											<h4 class="text-primary">'. $customerpayments[$i]['amount'] .' <i class="fa fa-rupee"></i></h4>
											<h6 class="m-0"><span class="badge '. $status_class .'">'. ucfirst($customerpayments[$i]['payment_mode']) .'</span></h6>
										</div>
									</div>
								</div>
							</div>';
		}
		
		if( $page_no > 1 ){
			$prev_page = "customerpayments.php?page_no=" . ($page_no - 1);
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$prev_page .= "&status=" . $_GET['status'];
			}
		}
		
		if( $page_context['has_more_page'] ){
			$page_no++;
			
			$next_page = "customerpayments.php?page_no=" . $page_no;
			
			if( isset($_GET) && isset($_GET['status']) && $_GET['status'] != "" ){
				$next_page .= "&status=" . $_GET['status'];
			}
		}
	}
	
	require_once("includes/header.php");
	require_once("includes/sidebar.php");
?>
	
	<div class="row">
		<div class="col-12">
			<div class="d-flex flex-wrap justify-content-between">
				<div>
					<h3 class="card-title m-0 pt-3">Customer Payments</h3>
				</div>
				<div>
					<div class="d-flex align-items-center">
						<select class="form-control" id="statusFltr">
							<?php echo $status_options; ?>
						</select>
					</div>
				</div>
			</div>
			<hr>
			<?php echo $html_str; ?>
			
			<?php if( (isset($prev_page) && $prev_page != "") || (isset($next_page) && $next_page != "") ){ ?>
			<div class="row mt-4">
				<div class="col-auto">
					<?php if(isset($prev_page) && $prev_page != ""){ ?>
					<a href="<?php echo $prev_page; ?>" class="btn btn-inverse-dark btn-fw">Previous</a>
					<?php } ?>
				</div>
				<div class="col"></div>
				<div class="col-auto">
					<?php if(isset($next_page) && $next_page != ""){ ?>
					<a href="<?php echo $next_page; ?>" class="btn btn-inverse-dark btn-fw">Next</a>
					<?php } ?>
				</div>
			</div>
			<?php }?>
		</div>
	</div>
	
<?php 

	require_once("includes/footer.php");
	
?>
                    